package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler6UpdateAll extends Handler{
	
	@Value(id = 0)
	int entityId;
	
	@Value(id = 1)
	int worldId;
	
	@Value(id = 2)
	NBTTagCompound data;
	
	public Handler6UpdateAll() {
		
	}
	
	public Handler6UpdateAll(EntityClone clone) {
		entityId = clone.entityId;
		worldId = clone.worldObj.provider.dimensionId;
		clone.writePublicData(data = new NBTTagCompound());
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.CLIENT){
			EntityClone clone = getCloneOnClient(entityId);
			if(clone != null){
				clone.readPublicData(data);
			}
		}
	}

}